//
// Copyright 2011 Justin.tv. All rights reserved.
//

@interface TWTableViewCell : UITableViewCell

typedef enum {
	TWTableViewCellContentVerticalAlignmentCenter  = 0,
	TWTableViewCellContentVerticalAlignmentTop     = 1,
	TWTableViewCellContentVerticalAlignmentBottom  = 2,
} TWTableViewCellContentVerticalAlignment;

extern NSString *const TWTableViewCellReuseIdentifier;

+ (NSString *)reuseIdentifier;
+ (CGFloat)preferredHeight;

- (void)commonInitialization;
- (void)loadImageAtURL:(NSString *)url fromCache:(TWCache *)cache persistently:(BOOL)persistently;

@property (nonatomic,strong) UIImage *image;
@property (nonatomic,copy) NSString *imageURL;
@property (nonatomic,copy) NSString *placeholderImageName;
@property (nonatomic,readwrite) CGSize imageSize;
@property (nonatomic,readwrite) CGFloat imagePadding;
@property (nonatomic,readwrite) UIEdgeInsets accessoryPadding;
@property (nonatomic,readwrite) CGPoint textLabelPositionAdjustment;
@property (nonatomic,readwrite) CGPoint detailTextLabelPositionAdjustment;
@property (nonatomic,readwrite) BOOL showsBottomSeparator;
@property (nonatomic,strong) UIColor *bottomSeparatorColor;
@property (nonatomic,strong) UIColor *accessoryTintColor;
@property (nonatomic,readwrite) CGFloat minimumTextIndentation;
@property (nonatomic,readwrite) TWTableViewCellContentVerticalAlignment contentVerticalAlignment;
@property (nonatomic,readwrite) BOOL shouldDownloadRedirectedImages;

@end
